// Generated by CoffeeScript 1.10.0
var exec, extractOptsAndCallback, getMac, isMac, isWindows, macRegex, zeroRegex;

exec = require('child_process').exec;

extractOptsAndCallback = require('extract-opts');

isWindows = process.platform.indexOf('win') === 0;

macRegex = /(?:[a-z0-9]{2}[:\-]){5}[a-z0-9]{2}/ig;

zeroRegex = /(?:[0]{2}[:\-]){5}[0]{2}/;

getMac = function(opts, next) {
  var command, data, extractMac, ref;
  ref = extractOptsAndCallback(opts, next), opts = ref[0], next = ref[1];
  data = opts.data;
  if (data == null) {
    data = null;
  }
  command = isWindows ? "getmac" : "ifconfig -a || ip link";
  extractMac = function(data, next) {
    var err, isZero, macAddress, match, result;
    result = null;
    while (match = macRegex.exec(data)) {
      macAddress = match[0];
      isZero = zeroRegex.test(macAddress);
      if (isZero === false) {
        if (result == null) {
          result = macAddress;
        }
      }
    }
    if (result === null) {
      err = new Error('could not determine the mac address from:\n' + data);
      return next(err);
    }
    return next(null, result);
  };
  if (data) {
    return extractMac(data, next);
  } else {
    return exec(command, function(err, stdout, stderr) {
      if (err) {
        return next(err);
      }
      return extractMac(stdout, next);
    });
  }
};

isMac = function(macAddress) {
  var ref;
  return ((ref = String(macAddress).match(macRegex)) != null ? ref.length : void 0) === 1;
};

module.exports = {
  macRegex: macRegex,
  getMac: getMac,
  isMac: isMac
};
